﻿/*****************************************************************************************************
* $$FileName		Update Images.jsx
*
* $$Description		Sample ExtendScript file to change the image file extension in any project, Plesae see the GetUpdatedImageName function
*
* Copyright (c) 2009 Adobe Systems Incorporated. All Rights Reserved.
******************************************************************************************************/

//global variables
main();

function main()
{
	var topicmanager = RoboHelp.project.TopicManager;
	var topic;
	for(var index=1;index<=topicmanager.count;index++)
	{
		topic = topicmanager.item(index);
		//we need update the topic now.
		UpdateFileImages(topic.path);
	}

	var snippetmanager = RoboHelp.project.SnippetManager;
	var snippet;
	for(var index=1;index<=snippetmanager.count;index++)
	{
		snippet = snippetmanager.item(index);
		//we need update the topic now.
		UpdateFileImages(snippet.path);
	}

}

function outputMsg(szString)
{
	RoboHelp.project.outputMessage (szString);
}

function GetUpdatedImageName(imagename)
{
	//we need to change from bmp to png
	var extension = imagename.substr(imagename.length-4);
	extension = extension.toLowerCase();
	if(extension=='.bmp')
	{
		extension= '.png';
		imagename = imagename.substr(0,imagename.length-4)+extension;
	}
	
	return imagename;
}

function UpdateFileImages(filepath)
{
	var msg = 'Reading File '+filepath+'\n';
	outputMsg(msg);
	
	//this is to get the token manager for the topic specified.
	var tokenmgr = RoboHelp.getTokenManager(filepath);
	var bSave = false;
	if(typeof(tokenmgr)!='undefined')
	{
		if(tokenmgr.count>0)
		{
			var token = tokenmgr.item(1);
			while(typeof(token)!='undefined')
			{
				//we have the token we need to check if this is the one we are worried about
				if(token.tokenType ==RoboHelp.TokenType.TOKENTAG && token.tagType==RoboHelp.TagType.TAGIMAGE)
				{
					//bSave = true;
					//we have got the image tag.
					//get the image src
					var imagename = token.getAttribute('src');
					//we need to update the image file name now
					var newimagename = GetUpdatedImageName(imagename);
					if(imagename!=newimagename)
					{
						msg = 'Changing image from -->'+imagename+' --> to --> '+newimagename+'-->\n';
						outputMsg (msg);
						//once we have the image name
						//update the src attribute in token
						token.setAttribute('src',newimagename);
						bSave = true;
					}
				}
				token = token.next;
			}
		}
		if(bSave)
		{
			tokenmgr.save();
			msg = 'Saving File '+filepath+'\n';
			outputMsg (msg);
		}
	}
}

